; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; iota

; ---conformance---
; Sketchy Extension

; ---purpose---
; Generate a sequence of natural numbers.
; The resulting sequence starts with 1
; and is in ascending order.

; ---args---
; N - maximum number in sequence.

; ---keywords---
; IOTA function, sequence of numbers, arithmetics, natural

; ---see-also---
; digits, sum, product, sort, unsort

; ---example---
; (iota 1 10) => (1 2 3 4 5 6 7 8 9 10)

;c lib/digits.l
;c lib/list.l
;c lib/append.l
;c lib/natural.l
;c lib/equal.l =
;c lib/plus.l +
;c lib/minus.l -

; ---model---
; (define (iota l h)
;   (cond ((= l h) (list l))
;     (#t (cons l (iota (+ l 1) h)))))

; ---code---
(define (iota l h)
  (letrec
    ((j (lambda (x r)
      (cond ((= x l) (cons l r))
        (#t (j (- x 1) (cons x r)))))))
    (cond ((> l h)
	(bottom '(bad range)))
      (#t (j h '())))))

