; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; intersection

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute the intersection of two sets.
; Sets are represented by lists of unique
; members.

; ---args---
; A - set
; B - set

; ---keywords---
; INTERSECTION function, intersection
; sets, set theory

; ---see-also---
; union, member, remove, unique, any?

; ---example---
; (intersection '(a b c) '(c x b)) => (b c)

;c lib/reverse.l
;c lib/member.l

; ---model---
; (define (intersection a b)
;   (cond ((null? a) '())
;     ((member (car a) b)
;       (cons (car a) (intersection (cdr a) b)))
;     (#t (intersection (cdr a) b))))

; ---code---
(define (intersection a b)
  (letrec
    ((_intersection (lambda (a r)
      (cond ((null? a) (reverse r))
        ((member (car a) b)
          (_intersection (cdr a) (cons (car a) r)))
        (#t (_intersection (cdr a) r))))))
    (_intersection a '())))

