; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; insert

; ---conformance---
; Sketchy Extension

; ---purpose---
; Insert a member into an ordered list.
; The predicate P must be asymmetrical
; and evaluate to #T for each two
; subsequent members of A.

; ---args---
; X - member to insert
; A - ordered list
; P - predicate defining the order of A

; ---keywords---
; INSERT function, sorting, insertion sort
; ordering, lists, ordered lists

; ---see-also---
; remove, sort, ordered?

; ---example---
; :l lib/less.l <
; (insert 4 '(3 5) <) => (3 4 5)

;c lib/append.l
;c lib/reverse.l

; ---model---
; (define (insert x a p)
;   (cond ((null? a) (cons x '()))
;     ((p x (car a)) (cons x a))
;     (#t (cons (car a) (insert x (cdr a) p)))))

; ---code---
(define (insert x a p)
  (letrec
    ((_insert (lambda (a r)
      (cond ((null? a)
          (reverse (cons x r)))
        ((p x (car a))
          (append (reverse (cons x r)) a))
        (#t (_insert (cdr a)
              (cons (car a) r)))))))
    (_insert a '())))

