; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; implode

; ---conformance---
; Sketchy Extension

; ---purpose---
; Implode a list of single-char symbols into a symbol.

; ---args---
; X - list of single-char symbols

; ---keywords---
; IMPLODE function, symbol, composition

; ---see-also---
; explode

; ---example---
; (implode '(h e l l o)) => hello

;c lib/not.l
;c lib/equal.l =
;c lib/s-length.l
;c lib/s-ref.l
;c lib/map.l

; ---code---
(define (implode x)
  (letrec
    ((sym->char (lambda (x)
      (let ((str (symbol->string x)))
        (cond ((not (= (string-length str) 1))
            (bottom '(bad symbol in implode)))
          (#t (string-ref str 0)))))))
    (string->symbol
      (list->string (map sym->char x)))))

