; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; hyper

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute A hyperN B.
; A, B, and N must all be natural numbers.

; ---args---
; N - list (order)
; A - list (base)
; B - list (hyper-exponent)

; ---keywords---
; HYPER function, hyper, hyper4, hyper5, base, exponent, power
; power tower

; ---see-also---
; digits, expt, fact

; ---example---
; (hyper 4 3 3) => 7625597484987

;c lib/digits.l
;c lib/equal.l =
;c lib/ntimes.l n*
;c lib/nexpt.l
;c lib/ngreater.l n>

; ---code---
(define (hyper n a b)
  (cond ((= n 0) (n+ b 1))
    ((= n 1) (n+ a b))
    ((= b 1) a)
    ((= n 2) (n* a b))
    ((= n 3) (nexpt a b))
    ((= n 4) (nexpt a (hyper n a (n- b 1))))
    ((n> n 4) (hyper (n- n 1) a (hyper n a (n- b 1))))))

; (defun hyper4 (a b) (hyper 4 a b))
; (defun hyper5 (a b) (hyper 5 a b))

