; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; head?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Check whether an expression X is the head of an
; expression Y.

; ---args---
; X - potential head
; Y - expression

; ---keywords---
; HEAD? function, list, pair, head

; ---see-also---
; tail?, caar, list?

; ---example---
; (head? '(a b c) '(a b c d e f)) => #t

;c lib/equalp.l equal?

; ---code---
(define (head? x y)
  (cond ((null? y) (null? x))
    ((null? x) #t)
    ((equal? (car x) (car y))
      (head? (cdr x) (cdr y)))
    (#t #f)))

