; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Solve the 'Towers of Hanoi'.

; ---args---
; N - number of disks

; ---keywords---
; HANOI function, Towers of Hanoi, example

; ---example---
; (hanoi 2) => ((from via) (from to) (via to))

;c lib/list.l
;c lib/append.l
;c lib/zerop.l zero?
;c lib/minus.l -

; ---code---
(define hanoi (lambda (n)
  (letrec
    ((_hanoi (lambda (from to via n)
      (cond ((zero? n) '())
        (#t (append
              (_hanoi from via to (- n 1))
              (list (list from to))
              (_hanoi via to from (- n 1))))))))
    (_hanoi 'from 'to 'via n))))

