; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Generate the lyrics of "99 bottles of beer on the wall".

; ---keywords---
; GEN-BOTTLES, 99 bottles of beer, example programs

; ---example---
; (bottles 99)

;c lib/append.l
;c lib/minus.l -
;c lib/zerop.l zero?

; ---code---
; Bottles Song in purely applicative Scheme
; Copyright (C) 2005 Nils M Holm <nmh@t3x.org>
;
; The below expression reduces to a list containing
; sublists. Each sublist contains one verse of the song.
; Each verse consists of four sublists. Each sublist of
; a verse contains one sentence.
;
; For example, the first verse of the song looks like
; this:
;
; ((99 bottles of beer on the wall)
;  (99 bottles of beer)
;  (take one down and pass it around)
;  (98 bottles of beer on the wall))

(define bottles (lambda n
  (letrec
  
    ; Define some sentences
    ((beers-on-wall
      (quote (bottles of beer on the wall)))
    (beer-on-wall
      (quote (bottle of beer on the wall)))
    (beers
      (quote (bottles of beer)))
    (beer
      (quote (bottle of beer)))
    (take-down
      (quote (take one down and pass it around)))
  
    ; Form a verse
    (verse (lambda (n)
      (append
        (list (append (list n)
                      (cond ((= n 1) beer-on-wall)
                        (#t beers-on-wall))))
        (list (append (list n)
                      (cond ((= n 1) beer)
                        (#t beers))))
        (list take-down)
        (list (append (list (- n 1))
                      (cond ((= n 2) beer-on-wall)
                        (#t beers-on-wall)))))))
  
    ; Collect the verses in a tail-recursive function
    (count-bottles (lambda (n lyrics)
      (cond ((zero? n) lyrics)
        (#t (count-bottles (- n 1)
              (append lyrics (list (verse n)))))))))
  
    (cond ((null? n)
        (count-bottles 99 '()))
      (#t (count-bottles (car n) '()))))))

