; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; filter

; ---conformance---
; Sketchy Extension

; ---purpose---
; Extract members from a list that match a given predicate.

; ---args---
; A - list
; P - predicate to match

; ---keywords---
; FILTER function, lists, filtering

; ---see-also---
; remove, some, every?

; ---example---
; (filter '(abc 123 def 456 ghi) number?) => (123 456)

;c lib/reverse.l

; ---model---
; (define (filter a p)
;   (cond ((null? a) '())
;     ((p (car a))
;       (cons (car a) (flt (cdr a) p)))
;     (#t (flt (cdr a) p))))

; ---code---
(define (filter a p)
  (letrec
    ((_filter (lambda (a b)
      (cond ((null? a) b)
        ((p (car a))
          (_filter (cdr a) (cons (car a) b)))
        (#t (_filter (cdr a) b))))))
    (_filter (reverse a) '())))

