; Sketchy Example Program
; Copyright (C) 2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; factors

; ---purpose---
; Compute the integer factors of N.

; ---args---
; N - number

; ---keywords---
; FACTORS function, integers, factorization, integer factorization

; ---see-also---
; expt, *, gcd

; ---example---
; (factors 24) => (* 3 (expt 2 3))

;c lib/digits.l
;c lib/zerop.l zero?
;c lib/modulo.l
;c lib/quotient.l
;c lib/plus.l +
;c lib/equal.l =
;c lib/list.l
;c lib/less.l <

; ---code---
(define (factors n)
  (letrec
    ((div-m (lambda (n m r)
      (cond ((zero? (modulo n m))
          (div-m (quotient n m) m (+ 1 r)))
        (#t (cons n r)))))
    (add-expt (lambda (b e r)
      (cond ((zero? e) r)
        ((= e 1) (cons b r))
        (#t (cons (list 'expt b e) r)))))
    (factorize (lambda (n d r)
      (let ((rest/exp (div-m n d 0)))
        (let ((m (car rest/exp))
              (e (cdr rest/exp)))
          (cond ((< m 2) (add-expt d e r))
            (#t (factorize m
                  (cond ((= d 2) 3)
                        (#t (+ d 2)))
                  (add-expt d e r)))))))))
    (cond ((< n 1)
	(bottom (list 'factors n)))
      ((= n 1) 1)
      (#t (let ((facts (factorize n 2 ())))
            (cond ((null? (cdr facts))
                (car facts))
              (#t (cons '* facts))))))))

