; Sketchy Example Program
; Copyright (C) 2005,2006 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; fact

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute X!. X must be a positive integer.
; This algorithm uses the "recursive product"
; algorithm (found under "factorial functions"
; at http://www.luschny.de/math/).

; ---args---
; X - number

; ---keywords---
; FAC function, factorial

; ---see-also---
; digits, expt, gcd, product, sum

; ---example---
; (fact 5) => 120

;c lib/digits.l
;c lib/zerop.l zero?
;c lib/negativep.l negative?

; ---model---
(define (fact x) 
  (cond ((zero? x) 1)
    (#t (* x (fact (- x 1))))))

; ---code---
(define (fact n)
  (letrec
    ((prod (lambda (n k)
      (cond ((< k 2) n)
	(#t (let ((l (quotient k 2)))
              (* (prod n l)
                 (prod (+ n l) (- k l)))))))))
    (cond ((negative? n)
        (bottom (list 'fact n)))
      (#t (prod 1 n)))))

