; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; explode

; ---conformance---
; Sketchy Extension

; ---purpose---
; Explode a symbol into single-char symbols.

; ---args---
; X - symbol

; ---keywords---
; EXPLODE function, symbol, decomposition

; ---see-also---
; implode

; ---example---
; (explode 'hello) => (h e l l o)

;c lib/string.l
;c lib/map.l

; ---code---
(define (explode x)
  (map (lambda (x)
         (string->symbol (string x)))
    (string->list (symbol->string x))))

