; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; every?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Verify that all members of a list have
; a given property. Return #T, if all
; members have the requested property and
; #F, if at least one member does not have
; the property.

; ---args---
; A - list
; P - predicate to test desired property

; ---keywords---
; EVERY? function, property, predicate

; ---see-also---
; any?, some, equal?

; ---example---
; (every? '(5 7 12) number?) => #t

; ---model---
; (define (every? x p)
;   (cond ((null? x) #t)
;     ((p (car x))
;       (every (cdr x) p))
;     (#t #f)))

; ---code---
(define (every? x p)
  (letrec
    ((_every? (lambda (x)
      (cond ((null? x) #t)
        ((p (car x)) (_every? (cdr x)))
        (#t #f)))))
    (_every? x)))

