; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; depth

; ---conformance---
; Sketchy Extension

; ---purpose---
; Compute the depth of a list. The depth
; of a list is the maximum number of nested
; lists enclosing any atom of the list.
; The depth of an atom is 0.

; ---args---
; A - list

; ---keywords---
; DEPTH function, list, member, depth, size

; ---see-also---
; count, length, append

; ---example---
; (depth '(a b (c (d) e) ((f)))) => 3

;c lib/max.l
;c lib/map.l

; ---code---
(define (depth a)
  (cond ((pair? a)
      (n+ 1 (apply max (map depth a))))
    (#t 0)))

