; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; count

; ---conformance---
; Sketchy Extension

; ---purpose---
; Recursively count the atoms of a list.
; Members of all sublists are included.

; ---args---
; X - list

; ---keywords---
; COUNT function, list, member, size

; ---see-also---
; length, depth, append

; ---example---
; (count '(a b (c (d) e) ((f)))) => 6

; ---model---
; (define (count x)
;   (cond ((null? x) 0)
;     ((pair? x)
;       (n+ (count (car x))
;         (count (cdr x))))
;     (#t 1)))

; ---code---
(define (count x)
  (letrec
    ((_count (lambda (x r s)
      (cond ((null? x)
          (cond ((null? s) r)
            (#t (_count (car s) r (cdr s)))))
        ((pair? x)
          (_count (car x) r (cons (cdr x) s)))
        (#t (_count '() (n+ r 1) s))))))
    (_count x 0 '())))

