; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Sort a list using the bubblesort algorithm.

; ---args---
; X - list to sort
; P - predicate defining the desired order

; ---keywords---
; BUBBLESORT function, bubble sort, sorting, example

; ---example---
; (bubblesort '(5 1 3 2 4) <) => (1 2 3 4 5)

:require orderedp.l ordered?
;c lib/caar.l cadr cddr

; ---code---
(define bubblesort (lambda (x p)
  (letrec ((bubble-up (lambda (x)
      (cond ((null? x) '())
        ((null? (cdr x)) x)
        ((p (car x) (cadr x))
          (cons (car x) (bubble-up (cdr x))))
        (#t (cons (cadr x)
              (bubble-up (cons (car x) (cddr x))))))))
    (bubble-step (lambda (x)
      (cond ((ordered? x p) x)
        (#t (bubble-step (bubble-up x)))))))
    (bubble-step x))))

