; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---purpose---
; Print the lyrics of "99 bottles of beer on the wall".

; ---keywords---
; BOTTLES, 99 bottles of beer, example programs

; ---example---
; (bottles 99)

;c lib/minus.l -
;c lib/equal.l =
;c lib/zerop.l zero?
;c lib/newline.l

; ---code---
(define (bottles . n)
  (letrec
  
    ((bottles (lambda (n suffix)
      (begin
        (display n)
        (cond ((= n 1) (display " bottle"))
          (#t (display " bottles")))
        (display suffix)
        (newline))))
      
    (verse (lambda (n)
      (begin
        (bottles n " of beer on the wall,")
        (bottles n " of beer.")
        (display "Take one down and pass it around,")
        (newline)
        (bottles (- n 1) " of beer on the wall."))))

    (count-bottles (lambda (n)
      (cond ((zero? n) 'done)
        (#t (begin
            (verse n)
            (newline)
            (count-bottles (- n 1))))))))

    (cond ((null? n)
        (count-bottles 99))
      (#t (count-bottles (car n))))))

