; Sketchy Example Program
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; any?

; ---conformance---
; Sketchy Extension

; ---purpose---
; Verify that at least one member of a list
; has a given property. Return #T, if a
; member with the given property exists and
; otherwise #F.

; ---args---
; A - list
; P - predicate to test desired property

; ---keywords---
; ANY? function, property, predicate

; ---see-also---
; every?, some, equal?

; ---example---
; (any '(a b c (x.y) d e f) pair?) => #t

; ---model---
; (define (any x p)
;   (cond ((null? x) #f)
;     ((p (car x)) #t)
;     (#t (any (cdr x) p))))

; ---code---
(define (any x p)
  (letrec
    ((_any (lambda (x)
      (cond ((null? x) #f)
        ((p (car x)) #t)
        (#t (_any (cdr x)))))))
    (_any x)))

