; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; zero?

; ---conformance---
; R5RS

; ---purpose---
; Test a number for being zero.

; ---args---
; X - number

; ---keywords---
; ZERO? function, zero, numbers, digit, equivalence
; identity, predicate

; ---see-also---
; digits, even?, negative?, positive?

; ---example---
; (zero? 0) => #t

(define zerop #t)

:require digits.l 0d
:require equal.l =

; ---model---
; (define (zero? x)
;   (= x 0))

; ---code---
(define (zero? x)
  (letrec ((zerop (lambda (list-x)
      (cond ((eq? (car list-x) 0d)
          (null? (cdr list-x)))
        (#t (= x 0))))))
    (zerop (integer->list x))))

