; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; *

; ---conformance---
; R5RS

; ---purpose---
; Multiply numbers.

; ---args---
; A... - numbers

; ---keywords---
; * function, times, multiply, multiplication, product
; arithmetics

; ---see-also---
; digits, +, -, quotient, remainder, n*

; ---example---
; (* 2 3 4) => 24

(define times #t)

:require digits.l
:require abs.l
:require minus.l -
:require integer.l
:require ntimes.l n*
:require zerop.l zero?
:require negate.l
:require iterate.l

; ---code---
(define (* . a)
  (letrec

    ((_itimes (lambda (a b)
      (cond
        ; avoid leading zeroes in result
        ((zero? a) 0)
        ; handle signs
        ((eq? (negative? a) (negative? b))
          (n* (abs a) (abs b)))
        (#t (negate (n* (abs a) (abs b)))))))

    (i* (lambda (a b)
      (_itimes (integer a) (integer b)))))

    (iterate i* a 1)))

