; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; succ

; ---conformance---
; Sketchy Core

; ---purpose---
; Find the successor of a decimal digit.
; -
; (SUCC 9) => NIL

; ---args---
; X - digit

; ---keywords---
; SUCC function, successor, numbers, digits

; ---see-also---
; digits, pred

; ---example---
; (succ 3d) => 4d

:require digits.l 0d 1d 2d 3d 4d 5d 6d 7d 8d 9d

; ---code---
(define succ (lambda (x)
  (cond ((eq? x 0d) 1d)
    ((eq? x 1d) 2d)
    ((eq? x 2d) 3d)
    ((eq? x 3d) 4d)
    ((eq? x 4d) 5d)
    ((eq? x 5d) 6d)
    ((eq? x 6d) 7d)
    ((eq? x 7d) 8d)
    ((eq? x 8d) 9d)
    ((eq? x 9d) '())
    (#t (bottom 'type-error)))))

