; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; substring

; ---conformance---
; R5RS

; ---purpose---
; Extract a substring from a string. The extracted string
; begins at the index START and extends to (but does not
; include) the char at the index END. The assertion
; 0<=START<=END must hold.

; ---args---
; STR - string
; START - position of first char to extract
; END - position of first char not to extract

; ---keywords---
; SUBSTRING function, string, substring, extract

; ---see-also---
; string, string-length, string-ref, string-append

; ---example---
; (substring "abcdefxyz" 3 6) => "def"

; (define substring #t)

:require zerop.l zero?
:require minus.l -
:require less.l <
:require reverse.l

; ---model---
; (define (substring str start end)
;   (letrec
;     ((skip (lambda (lst n)
;       (cond ((zero? n) lst)
;         ((null? lst)
;           (bottom '(bad start in substring)))
;         (#t (skip (cdr lst) (- n 1))))))
;     (extract (lambda (lst n res)
;       (cond ((zero? n) (reverse res))
;         ((null? lst)
;           (bottom '(bad end in substring)))
;         (#t (extract (cdr lst) (- n 1)
;           (cons (car lst) res)))))))
;     (cond ((< end start)
;         (bottom '(bad range in substring)))
;       (#t (list->string
;             (extract (skip (string->list str) start)
;               (- end start) '()))))))

; ---code---
; This function is a primitive function.

