; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string<?

; ---conformance---
; R5RS

; ---purpose---
; Test whether two strings are in ascending lexical order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING<? function, strings, comparison, lexical order,
; ascending

; ---see-also---
; string-ci<?, string=?, string>?, string<=?, string>=?, char<?, equal?

; ---example---
; (string<? "abc" "xyz") => #t

(define sltp #t)

:require not.l
:require cgtp.l char>?
:require cltp.l char<?

; ---code---
(define (string<? x y)
  (letrec ((lt? (lambda (x y)
      (cond ((null? x) (not (null? y)))
        ((null? y) #f)
        ((char<? (car x) (car y)) #t)
        ((char>? (car x) (car y)) #f)
        (#t (lt? (cdr x) (cdr y)))))))
    (lt? (string->list x) (string->list y))))

