; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string<=?

; ---conformance---
; R5RS

; ---purpose---
; Test whether two strings are in non-descending lexical order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING<=? function, strings, comparison, lexical order,
; non-descending

; ---see-also---
; string-ci<=?, string<?, string=?, string>?, string>=?, char<=?, equal?

; ---example---
; (string<=? "abc" "abc") => #t

(define slep #t)

:require sgtp.l string>?

; ---code---
(define (string<=? x y)
  (eq? (string>? x y) #f))

