; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; sketchy

; ---conformance---
; Sketchy Core

; ---purpose---
; Load the Sketchy core library into memory.

; ---keywords---
; Sketchy, procedures functions, routines, subroutines

(define sketchy #t)

; ---code---
(package 'sketchy)
:require abs.l
:require append.l
:require assoc.l
:require assq.l
:require booleanp.l boolean?
:require caaaar.l
:require caaar.l
:require caar.l
:require c-alphabeticp.l char-alphabetic?
:require c-cigep.l char-ci>=?
:require c-cigtp.l char-ci>?
:require c-cilep.l char-ci<=?
:require c-downcase.l
:require c-lower-casep.l char-lower-case?
:require c-numericp.l char-numeric?
:require c-upcase.l
:require c-upper-casep.l char-upper-case?
:require c-whitespacep.l char-whitespace?
:require cgep.l char>=?
:require cgtp.l char>?
:require clep.l char<=?
:require digits.l
:require divide.l
:require equal.l =
:require equalp.l equal?
:require evenp.l even?
:require expt.l
:require gcd.l
:require greater.l >
:require gteq.l >=
:require id.l
:require integer.l
:require iterate.l
:require lcm.l
:require length.l
:require less.l <
:require list-ref.l
:require list-tail.l
:require list.l
:require listp.l list?
:require lteq.l <=
:require map.l
:require max.l
:require member.l
:require memq.l
:require min.l -
:require minus.l -
:require modulo.l
:require natural.l
:require naturalp.l natural?
:require ndivide.l
:require negate.l
:require negativep.l negative?
:require neqp.l neq?
:require newline.l
:require nexpt.l
:require ngreater.l n>
:require ngteq.l n>=
:require nlteq.l n<=
:require non-negativep.l non-negative?
:require normalize.l
:require not.l
:require nquotient.l
:require nremainder.l
:require ntimes.l n*
:require numtostr.l number->string
:require oddp.l odd?
:require plus.l +
:require positivep.l positive?
:require quotient.l
:require remainder.l
:require reverse.l
:require sqrt.l
:require string.l
:require strtonum.l string->number
:require s-append.l
:require s-cieqp.l string-ci=?
:require s-cigtp.l string-ci>?
:require s-cigep.l string-ci>=?
:require s-ciltp.l string-ci<?
:require s-cilep.l string-ci<=?
:require s-length.l
:require s-ref.l
:require seqp.l string=?
:require sgtp.l string>?
:require sgep.l string>=?
:require sltp.l string<?
:require slep.l string<=?
:require substring.l
:require times.l *
:require zerop.l zero?
(package)

