; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string=?

; ---conformance---
; R5RS

; ---purpose---
; Test whether two strings are equal.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING=? function, strings, comparison, equivalence,
; lexical equivalence

; ---see-also---
; string-ci=?, string<?, string>?, string<=?, string>=?, char=?, equal?

; ---example---
; (string=? "xyz" "xyz") => #t

(define seqp #t)

:require equalp.l equal?

; ---code---
(define (string=? x y)
  (equal? (string->list x) (string->list y)))

