; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-ci<?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two strings are in
; lexically ascending order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING-CI<? function, strings, comparison, lexical order,
; ascending, case-insensitive

; ---see-also---
; string<?, string-ci=?, string-ci>?, string-ci<=?, string-ci>=?, char-ci<?
; equal?

; ---example---
; (string-ci<? "abc" "XYZ") => #t

(define s-ciltp #t)

:require not.l
:require c-cigtp.l char-ci>?
;require c-ciltp.l char-ci<?

; ---code---
(define (string-ci<? x y)
  (letrec
    ((ci-lt? (lambda (x y)
      (cond ((null? x) (not (null? y)))
        ((null? y) #f)
        ((char-ci<? (car x) (car y)) #t)
        ((char-ci>? (car x) (car y)) #f)
        (#t (ci-lt? (cdr x) (cdr y)))))))
    (ci-lt? (string->list x) (string->list y))))

