; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-ci<=?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two strings are in
; lexically non-descending order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING-CI<=? function, strings, comparison, lexical order,
; non-descending, case-insensitive

; ---see-also---
; string<=?, string-ci<?, string-ci=?, string-ci>?, string-ci>=?, char-ci<=?
; equal?

; ---example---
; (string-ci<=? "abc" "ABC") => #t

(define s-cilep #t)

:require s-cigtp.l string-ci>?

; ---code---
(define (string-ci<=? x y)
  (eq? (string-ci>? x y) #f))

