; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-ci>?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two strings are in
; lexically descending order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING-CI>? function, strings, comparison, lexical order,
; descending, case-insensitive

; ---see-also---
; string>?, string-ci<?, string-ci=?, string-ci<=?, string-ci>=?, char-ci>?
; equal?

; ---example---
; (string-ci>? "XYZ" "abc") => #t

(define s-cigtp #t)

:require s-ciltp.l string-ci<?

; ---code---
(define (string-ci>? x y)
  (string-ci<? y x))

