; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-ci>=?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two strings are in
; lexically non-ascending order.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING-CI>=? function, strings, comparison, lexical order,
; non-ascending, case-insensitive

; ---see-also---
; string>=?, string-ci<?, string-ci=?, string-ci>?, string-ci<=?, char-ci>=?
; equal?

; ---example---
; (string-ci>=? "XYZ" "xyz") => #t

(define s-cigep #t)

:require s-ciltp.l string-ci<?

; ---code---
(define (string-ci>=? x y)
  (eq? (string-ci<? x y) #f))

