; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-ci=?

; ---conformance---
; R5RS

; ---purpose---
; Case-insensitively test whether two strings are equal.

; ---args---
; X - string
; Y - string

; ---keywords---
; STRING-CI=? function, strings, comparison, equivalence,
; lexical equivalence, case-insensitive

; ---see-also---
; string=?, string-ci<?, string-ci>?, string-ci<=?, string-ci>=?, char-ci=?
; equal?

; ---example---
; (string-ci=? "xyz" "XYZ") => #t

(define s-cieqp #t)

;require c-cieqp.l char-ci=?

; ---code---
(define (string-ci=? x y)
  (letrec
    ((ci-eq? (lambda (x y)
      (cond ((null? x) (null? y))
        ((null? y) #f)
        ((char-ci=? (car x) (car y))
          (ci-eq? (cdr x) (cdr y)))
        (#t #f)))))
    (ci-eq? (string->list x) (string->list y))))

