; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; string-append

; ---conformance---
; R5RS

; ---purpose---
; Append strings.

; ---args---
; A - string
; B... - strings to be appended

; ---keywords---
; STRING-APPEND function, strings, appending

; ---see-also---
; string, string-length, string-ref, append

; ---example---
; (string-append "He" "llo " "World") => "Hello World"

(define s-append #t)

;require append.l
;require iterate.l

; ---model---
; (define (string-append a . b)
;   (letrec
;     ((append-str (lambda (a b)
;       (list->string (append (string->list a)
;         (string->list b))))))
;     (iterate append-str (cons a b) "")))

; ---code---
; This function is a primitive function.

