; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; reverse

; ---conformance---
; R5RS

; ---purpose---
; Reverse the order of members of a list.

; ---args---
; A - list

; ---keywords---
; REVERSE function, lists, reverse, ordering

; ---see-also---
; append, length, map, equal?, list?

; ---example---
; (reverse '(a b c d e f)) => (f e d c b a)

(define reverse #t)

;require list.l
;require append.l

; ---model---
; (define (reverse a)
;   (cond ((null? a) a)
;     (#t (append (reverse (cdr a))
;                 (list (car a))))))

; ---code---
(define (reverse a)
  (letrec
    ((_reverse (lambda (a b)
      (cond ((null? a) b)
        (#t (_reverse (cdr a) (cons (car a) b)))))))
    (_reverse a '())))

