; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; remainder

; ---conformance---
; R5RS

; ---purpose---
; Compute the remainder of the integer division of two numbers.

; ---args---
; A - number (dividend)
; B - number (divisor)

; ---keywords---
; REMAINDER function, division, remainder, division remainder
; modulus, arithmetics

; ---see-also---
; digits, quotient, modulo, divide, +, -, *, nremainder

; ---example---
; (remainder 123 -23) => 8

(define remainder #t)

:require divide.l
:require caar.l cadr

; ---code---
(define (remainder a b)
  (cadr (divide a b)))

