; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; pred

; ---conformance---
; Sketchy Core

; ---purpose---
; Find the predecessor of a decimal digit.
; -
; (PRED (DIGIT 0)) => NIL.

; ---args---
; X - digit

; ---keywords---
; PRED function, predecessor, numbers, digits

; ---see-also---
; digits, succ

; ---example---
; (pred 5d) => 4d

:require digits.l 0d 1d 2d 3d 4d 5d 6d 7d 8d 9d

; ---code---
(define pred (lambda (x)
  (cond ((eq? x 0d) '())
    ((eq? x 1d) 0d)
    ((eq? x 2d) 1d)
    ((eq? x 3d) 2d)
    ((eq? x 4d) 3d)
    ((eq? x 5d) 4d)
    ((eq? x 6d) 5d)
    ((eq? x 7d) 6d)
    ((eq? x 8d) 7d)
    ((eq? x 9d) 8d)
    (#t (bottom 'type-error)))))

