; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; positive?

; ---conformance---
; R5RS

; ---purpose---
; Check whether a number is positive.

; ---args---
; X - number

; ---keywords---
; POSITIVE? function, positive value, sign, predicate, numbers

; ---see-also---
; digits, negative?, zero?, abs

; ---example---
; (positive? 567) => #t

(define positivep #t)

:require digits.l
:require zerop.l zero?
:require negativep.l negative?

; ---code---
(define (positive? x)
  (eq? (or (negative? x) (zero? x)) #f))

