; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; +

; ---conformance---
; R5RS

; ---purpose---
; Add numbers.

; ---args---
; A... - numbers

; ---keywords---
; + function, plus, sum, addition, arithmetics

; ---see-also---
; digits, n+, -, quotient, remainder, *

; ---example---
; (+ 5 7 9) => 21

(define plus #t)

:require digits.l
:require abs.l
:require ngreater.l n>
:require minus.l -
:require integer.l
:require iterate.l
:require negativep.l negative?
:require non-negativep.l non-negative?
:require negate.l

; ---code---
(define (+ . a)
  (letrec

  ((_iplus (lambda (a b)
    (cond ((and (non-negative? a)
                (non-negative? b))
        (n+ (abs a) (abs b)))
      ((and (non-negative? a)
            (negative? b))
        (cond ((n> (abs a) (abs b))
            (- a (abs b)))
          (#t (negate (- (abs b) a)))))
      ((and (negative? a)
            (non-negative? b))
        (cond ((n> (abs a) (abs b))
            (negate (- (abs a) b)))
          (#t (- b (abs a)))))
      ; both negative
      (#t (negate (n+ (abs a) (abs b)))))))

    (i+ (lambda (a b)
      (_iplus (integer a) (integer b)))))

    (iterate i+ a 0)))

