; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; odd?

; ---conformance---
; R5RS

; ---purpose---
; Test a number N for being odd (N modulo 2 = 1).

; ---args---
; X - number

; ---keywords---
; ODD? function, odd, even, numbers, digit, predicate

; ---see-also---
; digits, even?, zero?

; ---example---
; (odd? 3) => #t

(define oddp #t)

:require digits.l
:require reverse.l
:require memq.l
:require not.l
;require evenp.l even?

; ---model---
; (define (odd? x)
;   (not (even? x)))

; ---code---
(define (odd? x)
  (not (eq? (memq
              (car (reverse (integer->list x)))
              (integer->list 13579))
         #f)))

