; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; number->string

; ---conformance---
; R5RS
; Accepts only strings representing integers.

; ---purpose---
; Convert a number to a string. The radix must be in the
; range 2..16. If no radix is given, 10 is assumed.

; ---args---
; N - integer
; RADIX - optional radix

; ---keywords---
; NUMBER->STRING function, string, integer, number, conversion

; ---see-also---
; string->number

; ---example---
; (number->string -2748 16) => "-abc"

(define numtostr #t)

:require zerop.l zero?
:require times.l *
:require list-ref.l *
:require quotient.l
:require remainder.l
:require less.l <
:require negativep.l negative?
:require abs.l

; ---code---
(define (number->string n . radix)
  (letrec
    ((digits (string->list "0123456789abcdef"))
    (conv (lambda (n rdx res)
      (cond ((zero? n) res)
        (#t (conv (quotient n rdx) rdx
              (cons (list-ref digits (remainder n rdx))
                    res))))))
    (get-radix (lambda ()
      (cond ((null? radix) 10)
        ((< 1 (car radix) 17) (car radix))
        (#t (bottom '(bad radix in number->string)))))))
    (cond ((zero? n) "0")
      ((negative? n)
        (list->string
          (cons #\- (conv (abs n) (get-radix) '()))))
      (#t (list->string (conv n (get-radix) '()))))))

