; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; n*

; ---conformance---
; Sketchy Core

; ---purpose---
; Compute the product of two natural numbers.

; ---args---
; A - natural number
; B - natural number

; ---keywords---
; N* function, times, multiply, multiplication, product
; arithmetics, natural

; ---see-also---
; digits, nquotient, nremainder, n+, n-, *

; ---example---
; (n* 4 5) => 20

(define ntimes #t)

:require digits.l 0d
:require list.l
:require append.l
:require reverse.l
:require zerop.l zero?

; ---code---
(define (n* a b)
  (letrec

    ; X*10 where X=/=0
    ((x10 (lambda (x)
      (list->integer
        (append (integer->list x) (list 0d))
        #t)))

    ; Add A to R B times.
    ; A,R are numbers, B is a decimal digit.
    (addn (lambda (a b r)
      (cond ((zero? b) r)
        (#t (addn a (n- b 1) (n+ a r))))))

    ; R=A*B
    ; B is in reverse order.
    (tms (lambda (a b r)
      (cond ((null? b) r)
        (#t (tms (x10 a) (cdr b)
              (addn a
                (list->integer
                  (list (car b)))
                r)))))))

    ; avoid leading zeroes in result
    (cond ((zero? a) 0)
      (#t (tms a (reverse (integer->list b))
            0)))))

