; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; nremainder

; ---conformance---
; Sketchy Core

; ---purpose---
; Compute the remainder of the division
; of two natural numbers.

; ---args---
; A - natural number (dividend)
; B - natural number (divisor)

; ---keywords---
; NREMAINDER function, division, remainder, division remainder
; modulus, arithmetics, natural

; ---see-also---
; digits, ndivide, nquotient, n*, n+, n-, remainder

; ---example---
; (nremainder 11 4) => 3

(define nremainder #t)

:require ndivide.l
:require caar.l cadr

; ---code---
(define (nremainder a b)
  (cadr (ndivide a b)))

