; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; nqoutient

; ---conformance---
; Sketchy Core

; ---purpose---
; Divide two natural numbers. Return their quotient.

; ---args---
; A - natural number (dividend)
; B - natural number (divisor)

; ---keywords---
; NQUOTIENT function, quotient, divide, division
; arithmetics, natural

; ---see-also---
; digits, ndivide, nremainder, n*, n+, n-, quotient

; ---example---
; (nquotient 11 4) => 2

(define nquotient #t)

:require ndivide.l

; ---code---
(define (nquotient a b)
  (car (ndivide a b)))

