; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; normalize

; ---conformance---
; Sketchy Core

; ---purpose---
; Normalize a number by removing leading zeroes and plus signs.

; ---args---
; X - number

; ---keywords---
; NORMALIZE function, normalize, normal form, canonical number
; GCD, reducing, numbers, digits

; ---see-also---
; digits, ndivide

; ---example---
; (normalize +000511) => 511

(define normalize #t)

:require digits.l 0d
:require caar.l cdar
:require caaar.l caadr cdadr
:require gcd.l
:require equal.l =
:require equalp.l equal?
:require quotient.l
:require minus.l -

; ---code---
(define (normalize x)
  (letrec
    ; remove leading zeroes from natural number
    ((skip0 (lambda (x)
      (cond ((null? (cdr x)) x)
        ((eq? (car x) 0d)
          (skip0 (cdr x)))
        (#t x))))
    (norm (lambda (x)
      (cond ((eq? (car x) '+)
          (skip0 (cdr x)))
        ((eq? (car x) '-)
          (let ((d (skip0 (cdr x))))
            (cond ((equal? d '(0d)) d)
              (#t (cons '- d)))))
        (#t (skip0 x))))))
    (list->integer
      (norm (integer->list x)) #t)))

