; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; non-negative?

; ---conformance---
; Sketchy Core

; ---purpose---
; Check whether a number is positive or zero.

; ---args---
; X - number

; ---keywords---
; NON-NEGATIVE? function, positive value, zero, sign, predicate, numbers

; ---see-also---
; digits, negative?, zero?, abs

; ---example---
; (non-negative? 0) => #t

(define non-negativep #t)

:require digits.l
:require negativep.l negative?

; ---code---
(define (non-negative? x)
  (eq? (negative? x) #f))

