; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; n-

; ---conformance---
; Sketchy Core

; ---purpose---
; Subtract two natural numbers.

; ---args---
; A - natural number
; B - natural number to be subtracted

; ---keywords---
; N- function, difference, subtract, subtraction
; arithmetics, natural

; ---see-also---
; digits, n+, nquotient, nremainder, n*, -

; ---example---
; (n- 7 5) => 2

(define nminus #t)

;require digits.l 0d 1d 9d
;require append.l
;require reverse.l
;require normalize.l
;require pred.l

; ---model---
; (define n- (lambda (a b)
;   (letrec
;     ; Compute difference of two digits with borrow
;     ; X Y - digits
;     ; CI CO - borrow (carry) in, out
;     ; RESULT - (difference . carry out)
;     ((d- (lambda (x y ci co)
;       (cond ((eq? y 0d)
;           (cond ((eq? ci 1d)
;               ; subtract carry in
;               (d- x 1d 0d co))
;             (#t (cons x co))))
;         ; handle overflow
;         ((null? (pred x))
;           (d- 9d (pred y) ci 1d))
;         (#t (d- (pred x) (pred y) ci co)))))
;     ; Subtract two lists of decimal digits forming reverse
;     ; decimal numbers. The result is in normal order.
;     ; A B - reverse lists of digits
;     ; C - carry flag
;     ; R - result (normal order)
;     (diff (lambda (a b c r)
;       (cond ((null? a)
;           (cond
;             ; A=() ; B=()
;             ((null? b)
;               (cond
;                 ; carry not set? OK
;                 ((eq? c 0d) r)
;                 ; A<B is undefined
;                 (#t (bottom
;                   'difference-negative))))
;             (#t (bottom 'difference-negative))))
;       ; A\=() ; B=() ; see above
;       ((null? b)
;         (cond
;           ; carry not set?
;           ((eq? c 0d)
;             ; prepend rest of A
;             (append (reverse a) r))
;           ; else subtract borrow
;           (#t (diff a (integer->list 1) 0d r))))
;       ; advance to next pair of digits
;       (#t
;         (diff (cdr a) (cdr b)
;           ; compute borrow
;           (cdr (d- (car a) (car b) c 0d))
;           ; prepend result digit
;           (cons (car (d- (car a) (car b) c 0d))
;             r)))))))
;     (normalize
;       (list->integer
;         (diff
;           (reverse (integer->list a))
;           (reverse (integer->list b))
;           0d '())
;         #t)))))

; ---code---
; This function is a primitive function.

