; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; n<=

; ---conformance---
; Sketchy Core

; ---purpose---
; Check whether two natural numbers are in non-descending
; order. Return #T, if A<=B (A not greater than B)
; and otherwise #F.

; ---args---
; A - natural number
; B - natural number

; ---keywords---
; N<= function, not greater than, less than or equal to,
; ordering, relation, comparison, predicate, natural

; ---see-also---
; digits, n>, n<=, =, <=

; ---example---
; (n<= 5 5) => #t

(define nlteq #t)

:require ngreater.l n>

; ---code---
(define (n<= a b)
  (eq? (n> a b) #f))

