; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; n<

; ---conformance---
; Sketchy Core

; ---purpose---
; Check if two natural numbers are in ascending
; order. Return #T, if A<B and otherwise #F.

; ---args---
; A - natural number
; B - natural number

; ---keywords---
; N< function, less than, ordering, relation
; comparison, predicate, natural

; ---see-also---
; digits, n>, n<=, n>=, =, <

; ---example---
; (n< 5 7) => #t

(define nless #t)

;require digits.l 0d
;require reverse.l
;require pred.l

; ---model---
; (define n< (lambda (a b)
;   (letrec
;     ; Check the ordering of two digits
;     ; A - digit
;     ; B - digit
;     ; Result: A<B-> #T; #F
;     ((d< (lambda (a b)
;       (cond ((eq? a b) #f)
;         ((eq? a 0d) #t)
;         ((eq? b 0d) #f)
;         (#t (d< (pred a) (pred b))))))
;     ; Check the inverse ordering of two digits
;     ; A - digit
;     ; B - digit
;     ; Result: A>B-> #T; #F
;     (d> (lambda (a b)
;       (d< b a)))
;     ; Check ordering.
;     ; A - reverse list of digits
;     ; B - reverse list of digits
;     ; R - result: member of {#T,#F}
;     (ltp (lambda (a b r)
;       (cond ((and (null? a) (null? b)) r) ; all compared
;         ((null? a) #t)        ; length[a] < length[b]
;         ((null? b) #f)        ; length[a] > length[b]
;         (#t (ltp (cdr a) (cdr b)
;           (cond ((d< (car a) (car b)) #t) ; default:
;             ((d> (car a) (car b)) #f) ; compare digits
;             (#t r))))))))
;     (ltp
;       (reverse (integer->list a))
;       (reverse (integer->list b))
;       #f))))

; ---code---
; This function is a primitive function.

