; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; nexpt

; ---conformance---
; Sketchy Core

; ---purpose---
; Compute the X raised to the power of Y.
; Both X and Y must be natural numbers.

; ---args---
; X - list (base)
; Y - list (exponent)

; ---keywords---
; NEXPT function, base, exponent, power

; ---see-also---
; digits, expt, gcd

; ---example---
; (nexpt 3 3) => 27

(define nexpt #t)

:require digits.l
:require zerop.l zero?
:require evenp.l even?
:require ntimes.l n*
:require nquotient.l

; ---model---
; (define (nexpt x y)
;   (cond ((zero? y) 1)
;     (#t (n* x (nexpt x (n- y 1))))))

; ---code---
(define (nexpt x y)
  (letrec
    ((square (lambda (x) (n* x x)))
    (_nexpt (lambda (y)
      (cond ((zero? y) 1)
        ((even? y)
          (square (nexpt x (nquotient y 2))))
        (#t (n* x (square (nexpt x (nquotient y 2)))))))))
    (_nexpt (natural y))))

