; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; neq?

; ---conformance---
; Sketchy Core

; ---purpose---
; Negative identity. Test two atoms for being not identical.

; ---args---
; X - atom
; Y - atom

; ---keywords---
; NEQ function, negative identity

; ---see-also---
; not, equal?

; ---example---
; (neq? 'a 'b) => #t

(define neqp #t)

; ---code---
(define (neq? x y)
  (eq? (eq? x y) #f))

