; Sketchy Library
; Copyright (C) 2005 Nils M Holm. All rights reserved.
; See the file LICENSE of the Sketchy distribution
; for conditions of use.

; ---name---
; negative?

; ---conformance---
; R5RS

; ---purpose---
; Check whether a number is negative.

; ---args---
; X - number

; ---keywords---
; NEGATIVE? function, negative value, sign, predicate

; ---see-also---
; digits, positive?, zero?, abs

; ---example---
; (negative? -567) => #t

(define negativep #t)

:require digits.l

; ---code---
(define (negative? x)
  (eq? (car (integer->list x)) '-))

